<?php
/*--------------------------------------------------------------------------------------------------
    PropertyQuantityReaderInterface.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Readers;

use Gambio\Shop\Properties\Properties\ValueObjects\CombinationId;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\CombinationQuantity;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities\PropertyTotalQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use ProductDataInterface;

interface PropertyQuantityReaderInterface
{
    
    /**
     * @param int $combinationId
     *
     * @return mixed
     */
    public function getQuantityByCombinationId(int $combinationId): ?float;
    
    
    /**
     * @param int $productId
     *
     * @return mixed
     */
    public function getTotalQuantityForProduct(int $productId) : ?float ;
}